#ifndef __KALUGA__MSG__HEADER__
#define __KALUGA__MSG__HEADER__

#include "FTNStruc.hpp"
#include "Common.hpp"
#include "Array.h"
#include "msgid.hpp"

// uncomment definition below to substitute Fidonet.org domain
// with Fidonet domain
#define SUBSTITUTE_DOMAIN

enum { SAVE_READ, SAVE_MIDDLE_OF_KLUDGE, SAVE_WRITE_LINE, SAVE_SKIP_LINE };

class CMsg {
private:
	uint16      m_wAttrs;
	uint16      m_wFlags;
	SYSTEMTIME  m_stTime;

	bool        m_fFMPTPresent;
	addr        m_wFMPT;

	bool        m_fTOPTPresent;
	addr        m_wTOPT;

	bool        m_fINTLPresent;
	SFTNAddress m_addrINTLFrom;
	SFTNAddress m_addrINTLTo;

	bool        m_fDOMAINPresent;
	SFTNAddress m_addrDomainKludgeFrom;
	SFTNAddress m_addrDomainKludgeTo;

	bool        m_fZoneGate;
	SFTNAddress m_addrRealTo;
	bool        m_fMsgIdPresent;
	bool        m_fMsgIdDecoded;
	SFTNAddress m_addrMsgIdFrom;
	TCHAR       m_szMsgIdLine[MAX_KLUDGE_SIZE];
	TCHAR       m_szArea[MAX_AREA_SIZE];
	HANDLE      m_hFile;
	bool        m_fMsgInBuf; // message in buffer or not
	DWORD       m_dwBodySize; // message body size
	CMsgId      m_MsgIdHandler;

	bool		m_fFlagsPresent;
	vector<tstring>	m_vFlags;

	TCHAR       m_szMsgFileName[MAX_PATH];
	TCHAR       m_szMsgFileDir[MAX_PATH];
	// address-treating functions
	void        DecodeAddresses();
	bool        ParsePT(LPCTSTR s, addr &PT);
	bool        ParseINTL(LPCTSTR s);
	bool        ParseFlags(LPCTSTR s);
	bool        ParseFTNAddress(LPCTSTR s, SFTNAddress &Address);
	bool        ParseMsgId(LPCTSTR s);
	bool        ParseDOMAIN(LPCTSTR s);
	// flags-treating fuctions
	void        SetFlag(LPCTSTR s);
	void        ClearFlag(LPCTSTR s);
	bool        CheckFlag(LPCTSTR s);
	// Adress-treating functions
	bool        FromNet(SFTNAddress &Addr) const; // checks Zone:Net
	bool        ToNet(SFTNAddress &Addr)  const;
	bool        FromNode(SFTNAddress &Addr)  const; // checks Zone:Net/Node
	bool        ToNode(SFTNAddress &Addr)  const;
	bool        FromPoint(SFTNAddress &Addr)  const; // checks Zone:Net/Node.Point
	bool        ToPoint(SFTNAddress &Addr)  const;
	// Name-treating functions
	bool        FromName(LPCTSTR szName) { return (lstrcmpi(m_Header.m_szFromUserName,
						       szName) == 0); }
	bool        ToName(LPCTSTR szName) { return (lstrcmpi(m_Header.m_szToUserName,
						     szName) == 0); }
	// Whole message treating functions
	/*
	bool        SaveMsg(FILE *tmp);
	void        Save();
	bool        Move(LPCTSTR szDir, long &FreeNumber);
	void        Bounce( uint16 wBounceAttrs, uint16 wBounceFlags,
			LPCTSTR szBounceTplFileName, SFTNAddress &BounceAddr );
	// user-defined fields and functions
	int         FromUs();
	int         ToUs();
	*/
	void	CloseFile() { CloseHandle(m_hFile); m_hFile = INVALID_HANDLE_VALUE; }
	CArray	m_arrMessage;

	/**
	 * Process message line
	 */
	void	ProcessLine(TCHAR kludgeTypeChar, LPTSTR lineData);

public:
	TCHAR	m_szToUserName[36];
	TCHAR	m_szFromUserName[36];

	TCHAR	m_szLastReplyFileName[MAX_PATH];

	long		m_lFreeMsgNumber;
	SMsgHeader	m_Header;
	SFTNAddress	m_addrFrom, m_addrTo;
	TCHAR		m_szSubject[72];
	CMsg();
	~CMsg();
	bool Read(LPCTSTR szMsgFName);
	void SetFreeMsgNumber(long lNumber) { m_lFreeMsgNumber = lNumber; }
	// these two are with domains (Zone:Net/Node.Point@Domain)
	bool  FromAddr(SFTNAddress &Addr);
	bool  ToAddr(SFTNAddress &Addr);
	bool  Delete();

	void Reply( uint16 wReplyAttrs, uint16 wReplyFlags, LPCTSTR szSubject,
		const vector<tstring> &vBodyLines );

	bool SaveAsReceived();
};

#endif